#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../scorpion.h"

#define NB_LUPIOTES (64)

#define FOND_Z 1000.f
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/FOND_Z}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

// longest codeline !
static DWORD dwId[] = {demon00,demon01,demon02,demon03,demon04,demon05,demon06,demon07,demon08,demon09,demon10,demon11,demon12,demon13,demon14,demon15,demon16,demon17,demon18,demon19,demon20,demon21,demon22,demon23,demon24,demon25,demon26,demon27,demon28,demon29,demon30,demon31,demon32,demon33,demon34,demon35,demon36,demon37,demon38,demon39};
#define NB_DEMONS (sizeof(dwId)/sizeof(DWORD))
static Obj3d Demon[NB_DEMONS];
static float Matrix[16], Matrix2[16];
static float Gouraud[16], Gouraud2[16];
static BYTE FireBuff[128*130];
static DWORD dwCoulor[NB_LUPIOTES];

static Obj3d *pCyl;

static float *sow, *tow;
static DWORD *A, *B, *C;

void LInit_Demon()
{
	DWORD Cpt1, Cpt2;
	DWORD dwDummy;
	FILE *file;
	DWORD dwNbVertices, dwNbFaces;
	DWORD dwTmp;

	pCyl = GenerateCylinder(7, 3, 150, 200, 256, 256);

	for(Cpt1=0;Cpt1<NB_DEMONS;Cpt1++)
	{
		LoadObject(&Demon[Cpt1], dwId[Cpt1], demonface);
		ComputeGouraud(&Demon[Cpt1]);
	}
	PrepareTextureFromArray(g_PicDemon, 256, 256, &g_TextureDemon);
	PrepareTextureFromArray(g_PicFlare2, 256, 256, &g_TextureFlare2);
	PrepareTextureFromArray(g_PicGlyphs, 256, 256, &g_TextureGlyphs);

	file = fopen(PackageName, "rb");
	SeekToSubfile(file, demonmap, &dwDummy);

	fread(&dwNbVertices, 4, 1, file);
	fread(&dwNbFaces, 4, 1, file);

	sow = (float*)malloc(dwNbVertices*sizeof(float));
	tow = (float*)malloc(dwNbVertices*sizeof(float));
	A = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));
	B = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));
	C = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));

	for(Cpt1=0;Cpt1<dwNbVertices;Cpt1++)
	{
		fread(sow+Cpt1, 4, 1, file);
		fread(tow+Cpt1, 4, 1, file);
	}

	for(Cpt1=0;Cpt1<dwNbFaces;Cpt1++)
	{
		fread(A+Cpt1, 4, 1, file);
		fread(B+Cpt1, 4, 1, file);
		fread(C+Cpt1, 4, 1, file);
	}

	for(Cpt2=0;Cpt2<NB_DEMONS;Cpt2++)
	for(Cpt1=0;Cpt1<dwNbFaces;Cpt1++)
	{
		Demon[Cpt2].pFace[Cpt1].SowA = sow[C[Cpt1]];
		Demon[Cpt2].pFace[Cpt1].TowA = tow[C[Cpt1]];
		Demon[Cpt2].pFace[Cpt1].SowB = sow[B[Cpt1]];
		Demon[Cpt2].pFace[Cpt1].TowB = tow[B[Cpt1]];
		Demon[Cpt2].pFace[Cpt1].SowC = sow[A[Cpt1]];
		Demon[Cpt2].pFace[Cpt1].TowC = tow[A[Cpt1]];
	}

	fclose(file);

	for(Cpt1=0;Cpt1<NB_LUPIOTES;Cpt1++)
	{
		dwCoulor[Cpt1] = CosTable[(Cpt1*8192*2/NB_LUPIOTES)&8191]*127.f+128.f
			+ ((DWORD)(CosTable[(Cpt1*8192*2/NB_LUPIOTES+2730)&8191]*127.f+128.f)<<8)
			+ ((DWORD)(CosTable[(Cpt1*8192*2/NB_LUPIOTES+5460)&8191]*127.f+128.f)<<16)
			+ (128<<24);
	}
}

void QInit_Demon()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grConstantColorValue(0xff0000);

	grAlphaTestFunction(GR_CMP_ALWAYS);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_POSITIVE);
	grFogMode(GR_FOG_DISABLE);
	grConstantColorValue(0x808080);

	DownloadTexture(&g_TextureDemon);
	DownloadTexture(&g_TextureFlare2);
	DownloadTexture(&g_TextureGlyphs);	
}

void Effect_Demon()
{
	DWORD Cpt1;
	static DWORD dwOddEven = 0;
	DWORD dwImg1;
	DWORD dwWhich;
	static Vector Tab[NB_LUPIOTES], CurrPos;
	static DWORD dwNbDraw = 0, dwCurrFirst = 0;
	static DWORD dwLastOut = 0;
	DWORD dwIntensity;
	DWORD dwTmp;
	DWORD dwSize;

	// cylinder
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	SelectTexture(g_TextureGlyphs);
	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect*16);
	DrawWithMatrix(pCyl, Matrix2, 0, 0, 0);

	dwImg1 = g_demostate.TickInEffect/16;

	// diablo !!!
	SelectTexture(g_TextureDemon);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	// matrix
	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 2048);
	// gouraud
	BeIdentityMatrix(Gouraud);
	RotateYMatrix(Gouraud2, Gouraud, SinTable[g_demostate.TickInEffect&8191]*1024);
	RotateXMatrix(Gouraud, Gouraud2, -2048+CosTable[(g_demostate.TickInEffect*2)&8191]*1024);
	
	TranslateMatrix(Matrix2, 0, 0, 80);

	dwWhich = (g_demostate.TickInEffect/64)%NB_DEMONS;
	DrawWithMatrix(&Demon[dwWhich], Matrix2, TRUE, Gouraud, 1);

	//
	// Lights
	//

	if (g_demostate.TickInEffect>10000-2048)
	{
		dwSize = (g_demostate.TickInEffect - (10000-2048))/16;
		if (dwSize>128)
			dwSize = 128;
		dwNbDraw = 8;
	}
	else
	{
		dwSize = 0;
	}

	SelectTexture(g_TextureFlare2);
	grDepthMask(FXFALSE);
	grCullMode(GR_CULL_DISABLE);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO);
	if (g_demostate.TickInEffect<1024)
	{
		CurrPos.x = 38+(1024-(int)g_demostate.TickInEffect)/64;
		CurrPos.y = (g_demostate.TickInEffect)/64-16;
		CurrPos.z = 80-16+(g_demostate.TickInEffect)/64;
	}
	else
	{
		dwTmp = ((g_demostate.TickInEffect-1024)*2)&8191;
		CurrPos.x = 38.f*CosTable[dwTmp];
		CurrPos.y = 13.f*SinTable[((g_demostate.TickInEffect-1024)*4)&8191];
		CurrPos.z = 38.f*SinTable[dwTmp]+80;
	}
	
	Draw3dSpriteSimple(17.f+dwSize, 17.f+dwSize, CurrPos.x, CurrPos.y, CurrPos.z);

	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	if (dwLastOut<g_demostate.TickInEffect-48)
	{
		dwLastOut = g_demostate.TickInEffect;
		if ((dwNbDraw<=NB_LUPIOTES)&&(g_demostate.TickInEffect<=10000-512))
			dwNbDraw++;
		dwCurrFirst = (dwCurrFirst+1)&(NB_LUPIOTES-1);
		Tab[dwCurrFirst].x = CurrPos.x;
		Tab[dwCurrFirst].y = CurrPos.y;
		Tab[dwCurrFirst].z = CurrPos.z;
	}
	dwIntensity = 256<<8;
	for(Cpt1=0;Cpt1<dwNbDraw;Cpt1++)
	{
		//grConstantColorValue(dwIntensity|(dwIntensity<<8)|(dwIntensity<<16));
		grConstantColorValue(dwCoulor[(dwCurrFirst-Cpt1)&(NB_LUPIOTES-1)]
			|((dwIntensity>>8)<<24));
		dwIntensity -= (256*8/NB_LUPIOTES);
		Draw3dSpriteSimple(
			17.f+dwSize, 17.f+dwSize, Tab[(dwCurrFirst-Cpt1)&(NB_LUPIOTES-1)].x, 
			Tab[(dwCurrFirst-Cpt1)&(NB_LUPIOTES-1)].y + Cpt1*3/2, 
			Tab[(dwCurrFirst-Cpt1)&(NB_LUPIOTES-1)].z);
	}

	grDepthMask(FXTRUE);
	grCullMode(GR_CULL_POSITIVE);
}

void ByeBye_Demon()
{
	FreeTexture(&g_TextureGlyphs);
	FreeTexture(&g_TextureFlare2);
	FreeTexture(&g_TextureDemon);
	g_TextureBuff.info.smallLod = GR_LOD_256;
	g_TextureBuff.info.largeLod = GR_LOD_256;
	g_TextureBuff.info.data = g_FrameBuf3d;
}